% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_reactive}
\alias{assert_reactive}
\title{Assert that x is reactive}
\usage{
assert_reactive(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if \code{x} is not reactive}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is a reactive, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert that x is reactive
}
\examples{
try({
# Assert that a variable is reactive
x <- shiny::reactive(1)
assert_reactive(x)  # does nothing

# Assert that a variable is not a list
x <- 1
assert_reactive(x)  # stops execution and prints an error message
})

}
\concept{assert_type}
