% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-data.R, R/is-data.R
\name{assert_all_are_hex_colors}
\alias{assert_all_are_hex_colors}
\alias{assert_any_are_hex_colors}
\alias{assert_all_are_hex_colours}
\alias{assert_any_are_hex_colours}
\alias{is_hex_color}
\alias{is_hex_colour}
\title{Does the character vector contain hex colors?}
\usage{
assert_all_are_hex_colors(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_hex_colors(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_hex_colours(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_hex_colours(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

is_hex_color(x)

is_hex_colour(x)
}
\arguments{
\item{x}{Input to check.}

\item{na_ignore}{A logical value.  If \code{FALSE}, \code{NA} values
cause an error; otherwise they do not.  Like \code{na.rm} in many
stats package functions, except that the position of the failing
values does not change.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
A logical vector that is \code{TRUE} when the input contains hex 
colours.
}
\description{
Checks that the input contains hexadecimal colors.
}
\note{
A string is considered to represent a hexadecimal colour when contains 
a hash followed by six hex values.  That is, digits or the letters from a to 
f (case insensitive).
}
\examples{
x <- c(
  "#012345", "#789abc", "#defDEF",  #ok
  "012345",                         #no hash
  "#g12345",                        #bad letter
  "#01 23 45",                      #contains spaces
  "#12345", "#1234567"              #wrong length
)
is_hex_color(x)
assert_any_are_hex_colors(x)
#These examples should fail.
assertive.base::dont_stop(assert_all_are_hex_colors(x))
}
