% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-in-range.R, R/is-in-range.R
\name{assert_all_are_in_closed_range}
\alias{assert_all_are_in_closed_range}
\alias{assert_all_are_in_left_open_range}
\alias{assert_all_are_in_open_range}
\alias{assert_all_are_in_range}
\alias{assert_all_are_in_right_open_range}
\alias{assert_all_are_negative}
\alias{assert_all_are_non_negative}
\alias{assert_all_are_non_positive}
\alias{assert_all_are_percentages}
\alias{assert_all_are_positive}
\alias{assert_all_are_proportions}
\alias{assert_any_are_in_closed_range}
\alias{assert_any_are_in_left_open_range}
\alias{assert_any_are_in_open_range}
\alias{assert_any_are_in_range}
\alias{assert_any_are_in_right_open_range}
\alias{assert_any_are_negative}
\alias{assert_any_are_non_negative}
\alias{assert_any_are_non_positive}
\alias{assert_any_are_percentages}
\alias{assert_any_are_positive}
\alias{assert_any_are_proportions}
\alias{is_in_closed_range}
\alias{is_in_left_open_range}
\alias{is_in_open_range}
\alias{is_in_range}
\alias{is_in_right_open_range}
\alias{is_negative}
\alias{is_non_negative}
\alias{is_non_positive}
\alias{is_percentage}
\alias{is_positive}
\alias{is_proportion}
\title{Is the input in range?}
\usage{
assert_all_are_in_closed_range(x, lower = -Inf, upper = Inf,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_any_are_in_closed_range(x, lower = -Inf, upper = Inf,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_all_are_in_left_open_range(x, lower = -Inf, upper = Inf,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_any_are_in_left_open_range(x, lower = -Inf, upper = Inf,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_all_are_in_open_range(x, lower = -Inf, upper = Inf,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_any_are_in_open_range(x, lower = -Inf, upper = Inf,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_all_are_in_range(x, lower = -Inf, upper = Inf,
  lower_is_strict = FALSE, upper_is_strict = FALSE, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_in_range(x, lower = -Inf, upper = Inf,
  lower_is_strict = FALSE, upper_is_strict = FALSE, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_in_right_open_range(x, lower = -Inf, upper = Inf,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_any_are_in_right_open_range(x, lower = -Inf, upper = Inf,
  na_ignore = FALSE, severity = getOption("assertive.severity", "stop"))

assert_all_are_negative(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_negative(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_non_negative(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_non_negative(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_non_positive(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_non_positive(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_percentages(x, lower_is_strict = FALSE,
  upper_is_strict = FALSE, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_percentages(x, lower_is_strict = FALSE,
  upper_is_strict = FALSE, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_positive(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_positive(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_all_are_proportions(x, lower_is_strict = FALSE,
  upper_is_strict = FALSE, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_proportions(x, lower_is_strict = FALSE,
  upper_is_strict = FALSE, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

is_in_closed_range(x, lower = -Inf, upper = Inf,
  .xname = get_name_in_parent(x))

is_in_left_open_range(x, lower = -Inf, upper = Inf,
  .xname = get_name_in_parent(x))

is_in_open_range(x, lower = -Inf, upper = Inf,
  .xname = get_name_in_parent(x))

is_in_range(x, lower = -Inf, upper = Inf, lower_is_strict = FALSE,
  upper_is_strict = FALSE, .xname = get_name_in_parent(x))

is_in_right_open_range(x, lower = -Inf, upper = Inf,
  .xname = get_name_in_parent(x))

is_negative(x, .xname = get_name_in_parent(x))

is_non_negative(x, .xname = get_name_in_parent(x))

is_non_positive(x, .xname = get_name_in_parent(x))

is_percentage(x, lower_is_strict = FALSE, upper_is_strict = FALSE,
  .xname = get_name_in_parent(x))

is_positive(x, .xname = get_name_in_parent(x))

is_proportion(x, lower_is_strict = FALSE, upper_is_strict = FALSE,
  .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{lower}{Lower bound for the interval.}

\item{upper}{Upper bound for the interval.}

\item{na_ignore}{A logical value.  If \code{FALSE}, \code{NA} values
cause an error; otherwise they do not.  Like \code{na.rm} in many
stats package functions, except that the position of the failing
values does not change.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{lower_is_strict}{If \code{TRUE}, the lower bound is open (strict)
otherwise it is closed.}

\item{upper_is_strict}{If \code{TRUE}, the upper bound is open (strict)
otherwise it is closed.}

\item{.xname}{Not intended to be used directly.}
}
\value{
The \code{is_*} functions return \code{TRUE} if the input is
within an interval.  The \code{assert_*} functions return nothing but
throw an error if the corresponding \code{is_*} function returns
\code{FALSE}.
}
\description{
Checks to see if the input is within an numeric interval.
}
\note{
\code{is_in_range} provides the most flexibility in determining
if values are within a numeric interval.  The other functions restrict
the input arguments for convience in common cases.  For example,
\code{is_percentage} forces the interval to be from 0 to 100.
The function is not vectorized by the \code{lower_is_strict} and
\code{upper_is_strict} for speed (these are assumed to be scalar logical
values).
}
\examples{
assert_all_are_positive(1:10)
assert_all_are_non_negative(0:10)
assert_any_are_positive(c(-1, 1))
assert_all_are_percentages(c(0, 50, 100))
assert_all_are_proportions(c(0, 0.5, 1))
assert_all_are_in_left_open_range(1 + .Machine$double.eps, lower = 1)
}

