% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-real-imaginary.R, R/is-real-imaginary.R
\name{assert_all_are_imaginary}
\alias{assert_all_are_imaginary}
\alias{assert_all_are_real}
\alias{assert_any_are_imaginary}
\alias{assert_any_are_real}
\alias{is_imaginary}
\alias{is_real}
\title{Is the input real/imaginary?}
\usage{
assert_all_are_imaginary(x, tol = 100 * .Machine$double.eps)

assert_any_are_imaginary(x, tol = 100 * .Machine$double.eps)

assert_all_are_real(x, tol = 100 * .Machine$double.eps)

assert_any_are_real(x, tol = 100 * .Machine$double.eps)

is_imaginary(x, tol = 100 * .Machine$double.eps)

is_real(x, tol = 100 * .Machine$double.eps)
}
\arguments{
\item{x}{Input to check.}

\item{tol}{Imaginary/real components smaller than \code{tol} are not
considered.}
}
\value{
\code{TRUE} if the input has imaginary component equal to zero.
The \code{assert_*} functions return nothing but
throw an error if the corresponding \code{is_*} function returns
\code{FALSE}.
}
\description{
Checks to see if the input is real or imaginary.
}
\examples{
(x <- with(expand.grid(re = -1:1, im = -1:1), re + im * 1i))
is_real(x)
is_imaginary(x)

# By default, very small imaginary/real components are ignored.
x <- .Machine$double.eps * (1 + 1i)
is_real(x)
is_real(x, 0)
is_imaginary(x)
is_imaginary(x, 0)
assert_all_are_real(1:10)
assert_all_are_real(1:10 + 0i)
assert_any_are_real(c(1i, 0))
assert_all_are_imaginary(1:10 * 1i)
assert_any_are_imaginary(c(1i, 0))
dont_stop(assert_all_are_real(x))
dont_stop(assert_all_are_imaginary(x))
}
\seealso{
\code{\link[base]{complex}}
}

