% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/are-same.R, R/assert-are-same.R
\name{are_same_length}
\alias{are_same_length}
\alias{assert_all_are_same_length}
\alias{assert_any_are_same_length}
\title{Are the inputs the same length}
\usage{
are_same_length(..., l = list())

assert_all_are_same_length(..., l = list())

assert_any_are_same_length(..., l = list())
}
\arguments{
\item{...}{Some R expressions.}

\item{l}{A list of R expressions.}
}
\value{
A symmetric square logical matrix which is \code{TRUE} where pairs
of inputs are the same length.
}
\description{
Checks if the inputs are the same length.
}
\examples{
x <- 1:5
are_same_length(
  runif(5), x, list(1, 2:3, 4:6, 7:10, 11:15), 1:6,
  l = list(seq.int(0, 1, 0.2), rnorm(5))
)
assert_any_are_same_length(runif(5), x, list(1, 2:3, 4:6, 7:10, 11:15), 1:6)
dont_stop(assert_all_are_same_length(runif(5), x, list(1, 2:3, 4:6, 7:10, 11:15), 1:6))
}
\seealso{
\code{\link[base]{length}}, \code{\link{are_identical}}
}

