% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/predicates.R
\name{not_na}
\alias{not_na}
\title{Returns TRUE if value is not NA}
\usage{
not_na(x, allow.NaN = FALSE)
}
\arguments{
\item{x}{A single atomic value}

\item{allow.NaN}{A logical indicating whether NaNs should be allowed
(default FALSE)}
}
\value{
TRUE if x is not NA, FALSE otherwise
}
\description{
This is the inverse of \code{\link[base]{is.na}} if it is
used on a atomic element. This is a convenience function meant
to be used as a predicate in an \code{\link{assertr}} assertion.
}
\examples{
not_na(NA)
not_na(2.8)
not_na("tree")
}
\seealso{
\code{\link{is.na}}
}

