% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{success_and_error_functions}
\alias{success_and_error_functions}
\alias{success_logical}
\alias{success_continue}
\alias{error_stop}
\alias{just_warn}
\alias{error_report}
\alias{warn_report}
\alias{error_append}
\alias{error_return}
\alias{error_logical}
\title{Success and error functions}
\usage{
success_logical(data, ...)

success_continue(data, ...)

error_stop(errors, data = NULL, warn = FALSE, ...)

just_warn(errors, data = NULL)

error_report(errors, data = NULL, warn = FALSE, ...)

warn_report(errors, data = NULL)

error_append(errors, data = NULL)

error_return(errors, data = NULL)

error_logical(errors, data = NULL, ...)
}
\arguments{
\item{data}{A data frame}

\item{...}{Further arguments passed to or from other methods}

\item{errors}{A list of objects of class \code{assertr_errors}}

\item{warn}{If TRUE, assertr will issue a warning instead of an error}
}
\description{
The behavior of functions like \code{assert}, \code{assert_rows},
\code{insist}, \code{insist_rows}, \code{verify} when the assertion
passes or fails is configurable via the \code{success_fun}
and \code{error_fun} parameters, respectively.
The \code{success_fun} parameter takes a function that takes
the data passed to the assertion function as a parameter. You can
write your own success handler function, but there are two
provided by this package:
\itemize{
  \item \code{success_continue} - just returns the data that was
                                   passed into the assertion function
  \item \code{success_logical} - returns TRUE
}
The \code{error_fun} parameter takes a function that takes
the data passed to the assertion function as a parameter. You can
write your own error handler function, but there are a few
provided by this package:
\itemize{
  \item \code{error_stop} - Prints a summary of the errors and
                            halts execution.
  \item \code{error_report} - Prints all the information available
                              about the errors and halts execution.
  \item \code{error_append} - Attaches the errors to a special
   attribute of \code{data} and returns the data. This is chiefly
   to allow assertr errors to be accumulated in a pipeline so that
   all assertions can have a chance to be checked and so that all
   the errors can be displayed at the end of the chain.
  \item \code{error_logical} - returns FALSE
  \item \code{just_warn} - Prints a summary of the errors but does
   not halt execution, it just issues a warning.
  \item \code{warn_report} - Prints all the information available
  about the errors but does not halt execution, it just issues a warning.
 }
}
