% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-fix}
\alias{node-fix}
\alias{node_replace}
\alias{node_replace_all}
\title{Change the code in the tree}
\usage{
node_replace(x, ...)

node_replace_all(x, ...)
}
\arguments{
\item{x}{A node, either from \code{\link[=tree_root]{tree_root()}} or from another \verb{node_*()}
function.}

\item{...}{Named elements where the name is a rule ID and the value is a
character string indicating the replacement to apply to nodes that match this
rule. Meta-variables are accepted but the syntax is different: they must be
wrapped in \verb{~~}, e.g \code{"anyNA(~~VAR~~)"}.}
}
\value{
A list where each element is the replacement for a piece of the code.
Each element is a list containing 3 sub-elements:
\itemize{
\item the start position for the replacement
\item the end position for the replacement
\item the text used as replacement
}
}
\description{
\code{node_replace()} gives the replacement for a particular node.
\code{node_replace_all()} does the same but for several nodes (e.g. the output of
\code{node_find_all()}). The output of those functions can be passed to
\code{tree_rewrite()} to rewrite the entire input code with those replacements.
}
\examples{
src <- "
x <- c(1, 2, 3)
any(duplicated(x), na.rm = TRUE)
any(duplicated(x))
if (any(is.na(x))) {
  TRUE
}
any(is.na(y))"

root <- tree_new(src) |>
  tree_root()


### Only replace the first nodes found by each rule

nodes_to_replace <- root |>
  node_find(
    ast_rule(id = "any_na", pattern = "any(is.na($VAR))"),
    ast_rule(id = "any_dup", pattern = "any(duplicated($VAR))")
  )

nodes_to_replace |>
  node_replace(
    any_na = "anyNA(~~VAR~~)",
    any_dup = "anyDuplicated(~~VAR~~) > 0"
  )

### Replace all nodes found by each rule

nodes_to_replace <- root |>
  node_find(
    ast_rule(id = "any_na", pattern = "any(is.na($VAR))"),
    ast_rule(id = "any_dup", pattern = "any(duplicated($VAR))")
  )

nodes_to_replace |>
  node_replace(
    any_na = "anyNA(~~VAR~~)",
    any_dup = "anyDuplicated(~~VAR~~) > 0"
  )
}
