% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sideinfo_lib.R
\name{sureshrink}
\alias{sureshrink}
\title{SureShrink estimator}
\usage{
sureshrink(d, v.d)
}
\arguments{
\item{d}{an n vector of observations}

\item{v.d}{an n vector of variances for each component of d}
}
\value{
\enumerate{
\item est - an n vector holding the estimates
\item t - estimated threshold
}
}
\description{
SureShrink estimator of a high dimensional sparse parameter from Donoho and Johnstone (1995)
}
\details{
Estimates a threshold t by minimizing the SURE function and then soft thresholds
    d using t.
}
\examples{
library(asus)
set.seed(42)
d<-rnorm(10,2,1)
v.d<- rep(1,10)
theta.hat<-sureshrink(d,v.d)

}
\references{
David L Donoho and Iain M Johnstone. Adapting to unknown smoothness via wavelet shrinkage.
Journal of the american statistical association, 90(432):1200-1224, 1995
}
\seealso{
\code{\link{sureshrink.mse}}
}
