% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.ata.R
\name{summary.ata}
\alias{summary.ata}
\alias{summary}
\title{Generic Summary Function for Class \code{ata}}
\usage{
\\method{summary}{ata}(object, ...)
}
\arguments{
\item{object}{An output object of class \code{ata} generated by either \code{wdm()} or \code{atalp()} from the package.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
The function returns a statement summarizing the evaluation of the assembled test form. Additionally, the function will return a pattern matrix for the test form constraints if assigned to an object.
\item{statement}{A summary of items (and/or item sets) in the test form and the overview of constraint success.}
\item{pattern}{A matrix of constraints by a classification if the additive constraints are below, at or above the constraint specific user provided bounds. This matrix, only returned if \code{summary.ata} is assigned to an object, will always demonstrate meeting all criteria for \code{atalp} test forms as all criteria have to be met to obtain a feasible solution.}
}
\description{
Default summary function for output objects of class \code{ata}. The function provides a brief summary of the ATA form in text, and provides a binary table of constraint success.
}
\author{
Gulsah Gurkan (gurkangulsah@gmail.com), Michael Chajewski (mchajewski@hotmail.com)
}
\keyword{"ata}
\keyword{"test}
\keyword{ata}
\keyword{form"}
\keyword{summary}
\keyword{summary"}
\keyword{test_form}
