% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-boxes.R
\name{plot_boxes}
\alias{plot_boxes}
\title{Plot layout of boxes!}
\usage{
plot_boxes(data, color_boxes = TRUE)
}
\arguments{
\item{data}{Dataframe to be plotted.}

\item{color_boxes}{logical indicating if polygons should be color coded or not. Default is \code{TRUE}.}
}
\value{
ggplot2 object
}
\description{
Plot layout of boxes!
}
\examples{
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
bgm_data <- convert_bgm(file.path(d, "VMPA_setas.bgm"))

# Use color coding for polygons.
plot_boxes(bgm_data)

# Only use text to indicate polygons.
plot_boxes(bgm_data, color_boxes = FALSE)
}
\seealso{
Other plot functions: \code{\link{plot_bar}},
  \code{\link{plot_diet_bec_dev}}, \code{\link{plot_diet}},
  \code{\link{plot_line}}, \code{\link{plot_rec}},
  \code{\link{plot_species}}
}
