% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-spatial-ts.R
\name{plot_spatial_ts}
\alias{plot_spatial_ts}
\title{Visualize the spatial distribution per species and stanza combination.}
\usage{
plot_spatial_ts(bio_spatial, bgm_as_df, vol, select_species = NULL,
  ncol = 7, polygon_overview = 0.2)
}
\arguments{
\item{bio_spatial}{Biomass per group and stanza in tonnes for each timestep,
layer and polygon. This dataframe should be generated with
\code{\link{calculate_biomass_spatial}}. The columns of the dataframe have to
be 'species', 'species_stanza', 'polygon', 'layer', 'time' and 'atoutput'.
Column 'atoutput' is the biomass in tonnes. Please use \code{\link{combine_ages}}
to transform an age-based dataframe to a stanza based dataframe.}

\item{bgm_as_df}{*.bgm file converted to a dataframe. Please use \code{\link{convert_bgm}}
to convert your bgm-file to a dataframe with columns 'lat', 'long', 'inside_lat',
'inside_long' and 'polygon'.}

\item{vol}{Volume per polygon and timestep. See model-preprocess.Rmd for details.}

\item{select_species}{Character vector listing the species to plot. If no species are selected
\code{NULL} (default) all available species are plotted.}

\item{ncol}{Number of columns in final plot. Default is \code{7}.}

\item{polygon_overview}{numeric value between 0 and 1 indicating the size used to plot the polygon overview in the
upper right corner of the plot. Default is \code{0.2}.}
}
\value{
grob of 3 ggplot2 plots.
}
\description{
Visualize the spatial distribution per species and stanza combination.
}
\examples{
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")

bgm_as_df <- convert_bgm(file.path(d, "VMPA_setas.bgm"))
vol <- agg_data(ref_vol, groups = c("time", "polygon"), fun = sum, out = "volume")

# Spatial distribution in Atlantis is based on adu- and juv stanzas.
# Therefore, we need to aggregate the age-based biomass to
# stanzas with \\code{\\link{combine_ages}}.
bio_spatial <- combine_ages(ref_bio_sp, grp_col = "species", agemat = ref_agemat)

# Apply \\code{\\link{plot_spatial_ts}}
grobs <- plot_spatial_ts(bio_spatial, bgm_as_df, vol)
gridExtra::grid.arrange(grobs[[1]])
gridExtra::grid.arrange(grobs[[7]])
}
