% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine-groups.R
\name{combine_groups}
\alias{combine_groups}
\title{Combine values from different groups if specific groups only have a low contribution to the overall value.}
\usage{
combine_groups(data, group_col, groups = names(data)[!is.element(names(data),
  c("atoutput", "time", group_col))], combine_thresh = 15)
}
\arguments{
\item{data}{Dataframe whose groups shall be combined.}

\item{group_col}{Character string giving the name of the group column in `data`.}

\item{groups}{Vector of character strings giving the grouping variables.}

\item{combine_thresh}{Integer indicating the number of groups to display. Default is \code{15}.}
}
\value{
dataframe with groups combined to "Rest" if contribution is low.
}
\description{
Combine values from different groups if specific groups only have a low contribution to the overall value.
}
\examples{
df <- combine_groups(ref_dm, group_col = "prey")
df <- combine_groups(ref_dm, group_col = "prey", combine_thresh = 2)
}
\seealso{
Other combine functions: \code{\link{combine_runs}}
}
