% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metrics.R
\name{get_metrics}
\alias{get_metrics}
\title{Get information about metrics from Axibase Time-Series Database.}
\usage{
get_metrics(expression = "", active = "", tags = "*", limit = 0,
  verbose = TRUE)
}
\arguments{
\item{expression}{Optional string argument.
Select metrics matching particular name pattern and/or user-defined metric tags.
The syntax of the \code{expression} argument is explained in the package vignette.
Type \code{browseVignettes(package = "atsd")} to see the vignette.}

\item{active}{Optional string argument: "true" or "false". 
Filter metrics by \code{lastInsertTime}. If 
\code{active = "true"}, 
only metrics with positive lastInsertTime are included in the response.}

\item{tags}{Optional string argument.
User-defined metric tags to be included in the response.
By default, all the tags will be included.}

\item{limit}{Optional integer argument.
If limit > 0, the response shows the top-N metrics ordered by name.}

\item{verbose}{Optional boolean argument.
If \code{verbose = FALSE} then all console output will be suppressed.
By default, \code{verbose = TRUE}.}
}
\value{
A data frame. 
    Each row of the data frame corresponds to a metric and its tags:
    \code{name}, 
    \code{counter},
    \code{lastInsertTime}
    and user-defined metric tags as requested by the 'tags' argument.
    For more information view the package vignette: 
    \code{browseVignettes(package = "atsd")}.
}
\description{
This function fetches a list of metrics and their tags from ATSD,
and converts it to a data frame.
}
\examples{
\dontrun{
# get all metrics and include all their tags in the data frame
get_metrics()

# get the top 100 active metrics which have tag, 'table', 
# include this tag into response and exclude oter user-defined metric tags
get_metrics(expression = "tags.table != ''", active = "true", 
            tags = "table", limit = 100)

# get metrics which have user-defined metric tag, 'table', 
# and whose name starts with 'cpu'
get_metrics(expression = "name like 'cpu*' and tags.table != ''")
            
# more complitcated expressions
get_metrics(expression = "likeAll(name, list('*disk*,*use*'))")
get_metrics(expression = "(name like 'cpu*' or tags.source = '') and tags.table like 'BC*'")
}
}
\seealso{
Visit
    \url{http://axibase.com/axibase-time-series-database/}
    for information about ATSD.
}
