% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attrCUSUM_getxxx_pois.R
\name{getContl_Poisson}
\alias{getContl_Poisson}
\alias{getContl_pois}
\alias{getContl_zipois}
\title{Compute Control Limits for FSI Poisson CUSUM Control Chart}
\usage{
getContl_pois(lambda, anss.target = 370.4, refv, c.zero = 0, maxndec = 7L,
  maxnumsubI = 6000L)

getContl_zipois(rho, lambda, anss.target = 370.4, refv, c.zero = 0,
  maxndec = 7L, maxnumsubI = 6000L)
}
\arguments{
\item{rho}{A length-one numeric vector of zero-inflated parameter in [0,1).}

\item{lambda}{A length-one positive numeric vector of mean.}

\item{anss.target}{A predetermined in-control ANSS/ARL (\eqn{\le}50000L),
default is 370.4.}

\item{refv}{A reference value of CUSUM statistic.}

\item{c.zero}{An initial state of CUSUM statistic (default is 0).}

\item{maxndec}{The maximum number of decimal places
of \code{refv} (\eqn{\le} 7L).}

\item{maxnumsubI}{The maximum number of sub-intervals in [100,6000] to be used in
applying the Markov chain approach.}
}
\value{
A list from \code{\link{getContl}}.
  See \code{\link{getContl}} for more information.
}
\description{
Computation of suitable control limits
   for (zero-inflated) FSI Poisson CUSUM control chart based on
   specified reference value and
   in-control ANSS/ARL.
}
\details{
\code{\link{getContl_pois}} and \code{\link{getContl_zipois}} are
  wrapper functions of \code{\link{getContl}} for
  (zero-inflated) Poisson distribution.
}
\examples{
# Example 1: Poisson distribution
getContl_pois(lambda = 4, anss.target = 200, refv = 5, c.zero = 0)
}
\references{
White et al. (1997).
   POISSON CUSUM VERSUS c CHART FOR DEFECT DATA,
   \emph{Quality Engineering}, \strong{9}:4, 673-679.
}
\seealso{
\code{\link{getContl}}, \link{getContl_binomial}.
}

