% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_freiburg.R
\name{gg_freiburg}
\alias{gg_freiburg}
\title{Freiburger Sprachtest data with ggplot2}
\usage{
gg_freiburg(data = data.frame(), NC_alpha = 0.6, HV_color = "grey")
}
\arguments{
\item{data}{a data.frame that is given to ggplot for initialization}

\item{NC_alpha}{value between 0 and 1 defining how prominent the "normal" curves are.}

\item{HV_color}{color of the Hörverlust-Scale in the
middle of the diagram.}
}
\value{
a ggplot suitable for adding Freiburger Sprachtest data as geom_*
}
\description{
Probably the most influential speech intelligibility test in German speaking countries.
This function serves as a starting point for plotting data in way that reflects the
usual representation of Freiburger Sprachtest results.
}
\examples{
library(ggplot2)
id = gl(25,4)
gender=gl(2,25, label =c("Frauen", "M\u00e4nner"))
x = rep(c(35, 50, 65, 80), 25)
y = 100*boltzmann(jitter(x,3), 45, .03)
example <- data.frame(Patient=id, Geschlecht = gender, x=x, y=y)
p <- gg_freiburg(NC_alpha = 1, HV_color = "grey") +
        geom_boxplot(aes(x = x, y = y, group = x), example) +
        geom_line(aes(x = x, y = y, color = Geschlecht, group = id), example)
print(p)
}
