% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelEvaluation.R
\name{modelEvaluation}
\alias{modelEvaluation}
\title{Create Model Evaluation explainer}
\usage{
modelEvaluation(object, variable = NULL)
}
\arguments{
\item{object}{An object of class ModelAudit.}

\item{variable}{Optional. Name of variable to order residuals. If value is NULL data order is taken. If value is "Predicted response" or "Fitted values" then data is ordered by fitted values. If value is "Observed response" the data is ordered by a vector of actual response (\code{y} parameter passed to the \code{\link{audit}} function).}
}
\description{
Creates modelEvaluation object to be plotted. Model evaluation concentrates on classification models.
}
\examples{
library(mlbench)
data("PimaIndiansDiabetes")
Pima <- PimaIndiansDiabetes
Pima$diabetes <- ifelse(Pima$diabetes == "pos", 1, 0)
glm_model <- glm(diabetes~., family=binomial,	data=Pima)
glm_au <- audit(glm_model, data = Pima, y = Pima$diabetes)

modelEvaluation(glm_au)


}
