% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_precision.R
\name{score_one_minus_precision}
\alias{score_one_minus_precision}
\title{One Minus Precision}
\usage{
score_one_minus_precision(object)
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}
}
\value{
An object of class 'auditor_score'.
}
\description{
One Minus Precision
}
\examples{
titanic <- na.omit(DALEX::titanic)
titanic$survived <- titanic$survived == "yes"

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)

#create an explainer
exp_glm <- DALEX::explain(model_glm, y = titanic$survived)

# calculate score
score_one_minus_precision(exp_glm)


}
