% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.R
\name{model_performance}
\alias{model_performance}
\alias{modelPerformance}
\title{Create Model Performance Explaination}
\usage{
model_performance(object, score = c("mae", "mse", "rec", "rroc"),
  new_score = NULL, data = NULL, ...)

modelPerformance(object, score = c("mae", "mse", "rec", "rroc"),
  new_score = NULL)
}
\arguments{
\item{object}{An object of class \code{explainer} created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{score}{Vector of score names to be calculated. Possible values: \code{acc}, \code{auc}, \code{cookdistance}, \code{dw}, \code{f1},
\code{gini}, \code{halfnormal}, \code{mae}, \code{mse}, \code{peak},
\code{precision}, \code{r2}, \code{rec}, \code{recall}, \code{rmse},
\code{rroc}, \code{runs}, \code{specificity},  \code{one_minus_acc}, \code{one_minus_auc},
\code{one_minus_f1}, \code{one_minus_gini}, \code{one_minus_precision}, \code{one_minus_recall}, \code{one_minus_specificity}
(for detailed description see functions in see also section). Pass \code{NULL} if you want to use only custom scores by \code{new_score} parameter.}

\item{new_score}{A named list of functions that take one argument: object of class 'explainer' and return a numeric value. The measure calculated by the function should have the property that lower score value indicates better model.}

\item{data}{New data that will be used to calcuate scores. Pass \code{NULL} if you want to use \code{data} from \code{object}.}

\item{...}{Other arguments dependent on the score list.}
}
\value{
An object of the class \code{auditor_model_performance}.
}
\description{
Creates \code{auditor_model_performance} object that can be used to plot radar with ranking of models.
}
\examples{
titanic <- na.omit(DALEX::titanic)
titanic$survived <- titanic$survived == "yes"

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)

# use DALEX package to wrap up a model into explainer
exp_glm <- DALEX::explain(model_glm, data = titanic, y = titanic$survived)

# validate a model with auditor
library(auditor)
model_performance(exp_glm)

}
\seealso{
\code{\link{score_acc}}, \code{\link{score_auc}}, \code{\link{score_cooksdistance}}, \code{\link{score_dw}},
\code{\link{score_f1}}, \code{\link{score_gini}},
\code{\link{score_halfnormal}}, \code{\link{score_mae}}, \code{\link{score_mse}},
\code{\link{score_peak}}, \code{\link{score_precision}}, \code{\link{score_r2}},
\code{\link{score_rec}}, \code{\link{score_recall}}, \code{\link{score_rmse}},
\code{\link{score_rroc}}, \code{\link{score_runs}}, \code{\link{score_specificity}},
\code{\link{score_one_minus_acc}}, \code{\link{score_one_minus_auc}}, \code{\link{score_one_minus_f1}},
\code{\link{score_one_minus_precision}}, \code{\link{score_one_minus_gini}},
\code{\link{score_one_minus_recall}}, \code{\link{score_one_minus_specificity}}
}
