% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm.R
\name{pfa.lm}
\alias{pfa.lm}
\title{PFA Formatting of Fitted Linear models}
\source{
pfa.config.R avro.typemap.R avro.R
}
\usage{
\method{pfa}{lm}(object, name = NULL, version = NULL, doc = NULL,
  metadata = NULL, randseed = NULL, options = NULL, ...)
}
\arguments{
\item{object}{an object of class "lm"}

\item{name}{a character which is an optional name for the scoring engine}

\item{version}{an integer which is sequential version number for the model}

\item{doc}{a character which is documentation string for archival purposes}

\item{metadata}{a \code{list} of strings that is computer-readable documentation for 
archival purposes}

\item{randseed}{a integer which is a global seed used to generate all random 
numbers. Multiple scoring engines derived from the same PFA file have 
different seeds generated from the global one}

\item{options}{a \code{list} with value types depending on option name
Initialization or runtime options to customize implementation 
(e.g. optimization switches). May be overridden or ignored by PFA consumer}

\item{...}{additional arguments affecting the PFA produced}
}
\value{
a \code{list} of lists that compose valid PFA document
}
\description{
This function takes a linear model fit using lm and 
returns a list-of-lists representing in valid PFA document 
that could be used for scoring
}
\examples{
X1 <- rnorm(100)
X2 <- runif(100)
Y <- 3 - 5 * X1 + 3 * X2 + rnorm(100, 0, 3)

model <- lm(Y ~ X1 + X2)
model_as_pfa <- pfa(model)
}
\seealso{
\code{\link[stats]{lm}} \code{\link{pfa.glm}}
}
