% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register.R
\name{aur_register}
\alias{aur_register}
\title{Create an AURIN authentication file.}
\usage{
aur_register(username, password, add_to_renviron = FALSE, overwrite = FALSE)
}
\arguments{
\item{username}{Character. AURIN API username.}

\item{password}{Character. AURIN API password.}

\item{add_to_renviron}{Logical. Default is \code{FALSE}. If \code{TRUE} then the file directory
of the authentication file will be added to your \code{.Renviron} file.}

\item{overwrite}{Logical. Default is \code{FALSE}. If \code{TRUE}, the existing \code{AURIN_API_USERPWD}
R environment variable will be replaced with new \code{username} and \code{password}.}
}
\description{
This function writes your AURIN API authentication as a R environment
variable of your current session. If \code{add_to_renviron} is \code{TRUE}, it
will write the API to your \code{.Renviron} file as \code{AURIN_API_USERPWD}.
}
\examples{
\dontrun{
aur_register("username", "password")
}
}
