\name{fractional_cover}
\alias{fractional_cover}
\title{Fractional cover based on TERN AusPlots data.
}
\description{Calculates fractional cover (i.e., the proportional cover of green vegetation, dead vegetation and bare substrate) based on plot-based point-intercept data from AusPlots (as generated by \code{\link{get_ausplots}}). 
}
\usage{
fractional_cover(veg.PI, ground_fractional="FALSE", in_canopy_sky="FALSE")
}
\arguments{
  \item{veg.PI}{The input raw point-intercept data as generated in the \code{\link{get_ausplots}} function.
}
  \item{ground_fractional}{Set to "TRUE" to calculate fractional GROUND cover.
}
  \item{in_canopy_sky}{Set to "TRUE" to include in green fraction, thereby calculating opaque canopy cover.
}
}
\details{Cover fractions are assigned according to the following:
	
'Green' or 'photosynthetic vegetation' is living vascular plant cover.

'Brown' or 'non-photosynthetic vegetation' is either vascular plant cover scored as 'dead' or substrate scored as litter, coarse woody debris or cryptogam (see below) that has no other veg cover.

'Bare' or 'bare ground' is substrate that is rock, outcrop, gravel or bare soil with no veg cover.

A height rule is applied so that coding to green/brown/bare of the uppermost substrate/vegetation stratum hit at a given point intercept location overrides the others. That is, a dead tree overrides a living shrub beneath and vice versa; substrate coding is overriden by any vegetation cover etc. This means for each of the (usually) 1010 intercepts, there is a single coding and percentage is the number of hits assigned to each fraction, divided by the total number of PIs taken (usually 1010 but can vary) times 100.

There is an option via argument 'ground_fractional' to calculate fractional ground cover - the same concept applied to only grasses (hummock, tussock, other); sedge; rush; forb; fern; and vine plant growth forms. Presently, cryptogam cover is excluded and included in the non-photosynthetic fraction.

'In canopy sky' is excluded by default (only the substrate is considered for those hits) and applies only to regular fractional cover (as trees are excluded in the green fraction for ground fractional cover by default).

Currently, cryptogam substrate is assigned to the non-photosynthetic fraction.

Occasionally substrate type was not collected ('NC') or could not be assigned to one of the above categories ('Unknwn'), in which case a percent cover will be returned under an 'NA' fraction if there was no veg cover above those points.

}
\value{Returns a data frame in which plots are rows, columns are fractions (bare, brown, green and NA) and values are percent cover.
}
\author{Greg Guerin
}


\seealso{
\code{\link{get_ausplots}}
}
\examples{
#get veg.PI data for selected plots:
my.data <- get_ausplots(my.Plot_IDs=c("SATFLB0004", "QDAMGD0022", "NTASTU0002"),
	veg.vouchers=FALSE, site_info=FALSE)

#calculate fractional cover:
fractional_cover(my.data$veg.PI)
}
