% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoSEM.R
\name{autoSEM}
\alias{autoSEM}
\title{This function houses a number of different heuristic optimization algorithms
    for specification search.}
\usage{
autoSEM(method = "GA", data = NULL, nfac = NULL, varList = NULL,
  criterion = "BIC", minInd = 3, niter = "default", parallel = "no",
  missing = "listwise", CV = "boot", R = 100, min.improve = niter,
  seed = NULL, std.lv = TRUE, ...)
}
\arguments{
\item{method}{which optimization algorithm to use. Currently, it is only
recommended to use "GA" for the genetic algorithm from the GA
package, "aco", an implementation of the ant colony
algorithm by Ross Jacobucci, and "tabu", an implementation of
the Tabu search procedure by Ross Jacobucci. The latter two
algorithms are based on the book chapter by Marcoulides &
Leite, 2013.}

\item{data}{a required dataset to search with.}

\item{nfac}{the number of factors to test.}

\item{varList}{list containing the names of the
variables to use from the dataset.}

\item{criterion}{The fit index to use as a criterion for
choosing the best model. Current options are "NCP",
"RMSEA","AIC", "BIC", and "BIC2", which is the sample
size adjusted BIC.}

\item{minInd}{The minimum number of indicators per factor.}

\item{niter}{The maximum number of iterations to use. "default" changes the number
of iterations based on the algorithm used.}

\item{parallel}{Whether to use the snowfall package for parallelization.
Note that this is only applicable for the GA package at this time.}

\item{missing}{Argument to be passed to cfa() as to what to do with missing
values. Note: missing="fiml" can't be paired with CV=TRUE}

\item{CV}{Whether to use cross-validation for choosing the best model. The
default is to use fit indices without CV.It is currently recommended to either
use FALSE or "boot". Note that "boot" will take significantly longer.}

\item{R}{If using bootstrap, how many samples to take? Default is 100}

\item{min.improve}{Number of iterations to wait for improvement
before breaking.}

\item{seed}{random seed number.}

\item{std.lv}{Defaults to true. So lavaan uses all variables for each factor}

\item{...}{Additional arguments to pass to cfa(). An example is
is setting orth=FALSE,std.lv=TRUE.}
}
\value{
fit the fit index

solution the solution with the best fit

out returned object from optimization algorithm
}
\description{
This function houses a number of different heuristic optimization algorithms
    for specification search.
}
\examples{
library(autoSEM)
myData =  HolzingerSwineford1939[,7:15]

f1.vars <- c("x1","x2","x3","x4","x5","x6","x7","x8","x9")

out = autoSEM(method="GA",data=myData,nfac=1,
             varList=list(f1.vars),CV=FALSE,
             criterion="RMSEA",minInd=3,niter=1)
summary(out)

}
\keyword{autoSEM}

