% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available.R
\name{available}
\alias{available}
\title{See if a name is available}
\usage{
available(name, browse = getOption("available.browse", TRUE), ...)
}
\arguments{
\item{name}{Name of package to search}

\item{browse}{Whether browser should be opened for all web links,
default = TRUE. Default can be changed by setting
\code{available.browse} in \code{.Rprofile}. See \link[base]{Startup}
for more details.}

\item{...}{Additional arguments passed to [utils::available.packages()].}
}
\description{
Searches performed
- Valid package name
- Already taken on CRAN
- Positive or negative sentiment
- Urban Dictionary
}
\examples{
\dontrun{
# Check if the available package is available
available("available")

# You can disable opening of browser windows with browse = FALSE
available("survival", browse = FALSE)

# Or by setting a global option
options(available.browse = FALSE)
available("survival")
}
}
