% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avar.r
\name{boostrap_ci_avlr}
\alias{boostrap_ci_avlr}
\title{Compute bootstrap confidence intervals for the AVLR estimator}
\usage{
boostrap_ci_avlr(model, B, n, qn, wn, rw, dr, alpha)
}
\arguments{
\item{model}{A \code{ts.model} object that was estimated with the avlr function.}

\item{B}{A \code{double} for the number of bootsrap replicates to compute the confidence intervals.}

\item{n}{A \code{double} with the sample size.}

\item{qn}{A \code{vec} specifying on which scales the parameters of a Quantization Noise (QN) was computed.}

\item{wn}{A \code{vec} specifying on which scales the parameters of a White Noise (WN) was computed.}

\item{rw}{A \code{vec} specifying on which scales the parameters of a Random Wakk (RW) was computed.}

\item{dr}{A \code{vec} specifying on which scales the parameters of a Drift (DR) was computed.}

\item{alpha}{A \code{double} defining the level of the confidence interval (1 - `alpha`).}
}
\value{
A \code{list} that contains:
\itemize{
 \item{"ci"}{The 1-\code{alpha} confidence intervals.}
 \item{"sd"}{The standard deviation of the estimated parameters.}
}
}
\description{
Compute bootstrap confidence intervals for the AVLR estimator
}
\keyword{internal}
