% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AVNS_theo_covmat.R
\name{covmat_bi}
\alias{covmat_bi}
\title{Calculate Theoretical Covariance Matrix of Bias-Instability Process}
\usage{
covmat_bi(sigma2, n_total, n_block)
}
\arguments{
\item{sigma2}{A \code{double} value for the variance parameter \eqn{\sigma ^2}{sigma^2}.}

\item{n_total}{An \code{integer} indicating the length of the whole bias-instability process.}

\item{n_block}{An \code{integer} indicating the length of each block of the bias-instability
process.}
}
\value{
The theoretical covariance \code{matrix} of the bias-instability process.
}
\description{
This function allows us to calculate the theoretical covariance matrix of a bias-instability
process.
}
\note{
This function helps calculate the theoretical covariance matrix of a non-stationary
process, bias-instability. It is helpful to calculate the theoretical allan variance of
non-stationary processes, which can be used to compare with the theoretical allan variance
of stationary processes as shown in "A Study of the Allan Variance for Constant-Mean Non-Stationary
Processes" by Xu et al., 2017, IEEE Signal Processing Letters, 24(8): 1257–1260.
}
\examples{
covmat1 = covmat_bi(sigma2 = 1, n_total = 1000, n_block = 10)
covmat2 = covmat_bi(sigma2 = 2, n_total = 800, n_block = 20)
}
\author{
Yuming Zhang
}
