% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avfintools.R
\name{get15}
\alias{get15}
\title{Get Stock Data at the 15 minute level localized to current time zone}
\usage{
get15(ticker, truncated = TRUE)
}
\arguments{
\item{ticker}{The ticker symbol as a string}

\item{truncated}{Option to limit output to hours closer to market open hours. Default is true.}
}
\value{
A data frame with daily data such as the high, low, open, close, and associated returns. Available in the global environment.
Default is truncated to show data more relevant to active trading hours. Adjusted to local time zone.
}
\description{
Summary statistics for the movements on the 15 minute level
}
\examples{
\dontrun{
get15("WTI")
get15("SPY", truncated = FALSE)
}
}
