% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_transcriptome_seq_from_transcriptome_id.R
\name{get_transcriptome_seq_from_transcriptome_id}
\alias{get_transcriptome_seq_from_transcriptome_id}
\title{Get transcriptome sequence from transcriptome}
\usage{
get_transcriptome_seq_from_transcriptome_id(
  transcriptome_id,
  seed_id = FALSE,
  transcriptome_pos = FALSE,
  genome_seq = FALSE,
  triplestore
)
}
\arguments{
\item{transcriptome_id}{Integer or list of integer values.}

\item{seed_id}{Integer (from 1 to 1000), a vector of integer
values, or a logical value. This integer is used for starting the
pseudo-random number generator that represents the environment experiencing a
digital organism. If a logical value is used, TRUE returns data found in all
environments and FALSE (by default) returns only distinct data regardless of
the seed.}

\item{transcriptome_pos}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}

\item{genome_seq}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}

\item{triplestore}{Object of class triplestore_access which manages database
access.}
}
\value{
data frame. Columns: "seed_id" (optional), "transcriptome_id",
"transcriptome_seq", "transcriptome_pos" (optional), "genome_seq" (optional).
}
\description{
Get the transcriptome sequence of the transcriptome executed by
a digital organism for a list of seeds used for starting the pseudo-random
number generator (i.e., a set of environments).
}
\examples{

# Create triplestore object
avidaDB <- triplestore_access$new()

# Set access options
avidaDB$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)

# Single transcriptome
get_transcriptome_seq_from_transcriptome_id(
  transcriptome_id = 53674,
  triplestore = avidaDB
)

# More than one transcriptome at seed_1
get_transcriptome_seq_from_transcriptome_id(
  transcriptome_id = c(53674, 1666099),
  seed_id = 1,
  triplestore = avidaDB
)

# At seed_1 and seed_3
get_transcriptome_seq_from_transcriptome_id(
  transcriptome_id = 2,
  seed_id = c(1, 3),
  transcriptome_pos = TRUE,
  triplestore = avidaDB
)

}
