% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_deprovision_byoip_cidr}
\alias{ec2_deprovision_byoip_cidr}
\title{Deprovision Byoip Cidr}
\usage{
ec2_deprovision_byoip_cidr(
  Cidr,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Cidr}{String. The address range, in CIDR notation.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deprovision Byoip Cidr
}
\section{Cidr}{

The address range, in CIDR
notation. The prefix must be the same prefix that you specified when you
provisioned the address range.
}

\section{DryRun}{

Checks whether you
have the required permissions for the action, without actually making
the request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

