% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_iam_instance_profile_associations}
\alias{ec2_describe_iam_instance_profile_associations}
\title{Describe Iam Instance Profile Associations}
\usage{
ec2_describe_iam_instance_profile_associations(
  AssociationId = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{AssociationId}{List. The IAM instance profile associations.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{NextToken}{Characters. The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describes your IAM instance profile
associations.
}
\section{AssociationId}{

The IAM instance profile
associations.
}

\section{Filter}{


The filters.
\itemize{
\item \code{instance-id} - The ID of the instance.
\item \code{state} - The state of the association (\code{associating} \|
\code{associated} \| \code{disassociating}).
}
}

\section{MaxResults}{

The maximum number of results to return in a single
call. To retrieve the remaining results, make another call with the
returned \code{NextToken} value.
}

