% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_vpn_connection_options}
\alias{ec2_modify_vpn_connection_options}
\title{Modify Vpn Connection Options}
\usage{
ec2_modify_vpn_connection_options(
  VpnConnectionId,
  LocalIpv4NetworkCidr = NULL,
  RemoteIpv4NetworkCidr = NULL,
  LocalIpv6NetworkCidr = NULL,
  RemoteIpv6NetworkCidr = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{VpnConnectionId}{Character. The ID of the Site-to-Site VPN connection.}

\item{LocalIpv4NetworkCidr}{Character.   The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.[optional]}

\item{RemoteIpv4NetworkCidr}{Character.   The IPv4 CIDR on the AWS side of the VPN connection.  Default: \verb{0.0.0.0/0}  [optional]}

\item{LocalIpv6NetworkCidr}{Character.   The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.[optional]}

\item{RemoteIpv6NetworkCidr}{Character.   The IPv6 CIDR on the AWS side of the VPN connection.  Default: \verb{::/0}  [optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Modify Vpn Connection Options
}
\section{VpnConnectionId}{

The ID of the Site-to-Site
VPN connection.
}

\section{LocalIpv4NetworkCidr}{


The IPv4 CIDR on the customer gateway (on-premises) side of the VPN
connection.

Default: \verb{0.0.0.0/0}
}

\section{RemoteIpv4NetworkCidr}{


The IPv4 CIDR on the AWS side of the VPN connection.

Default: \verb{0.0.0.0/0}
}

\section{LocalIpv6NetworkCidr}{


The IPv6 CIDR on the customer gateway (on-premises) side of the VPN
connection.

Default: \verb{::/0}
}

\section{RemoteIpv6NetworkCidr}{


The IPv6 CIDR on the AWS side of the VPN connection.

Default: \verb{::/0}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

