% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_untag_resource}
\alias{ecs_untag_resource}
\title{Untag Resource}
\usage{
ecs_untag_resource(
  resourceArn = NULL,
  tagKeys = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{resourceArn}{Character. The Amazon Resource Name (ARN) of the resource from which to delete tags.}

\item{tagKeys}{List. The keys of the tags to be removed.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Deletes specified tags from a
resource.
}
\section{resourceArn}{

The Amazon Resource Name (ARN) of the resource from
which to delete tags. Currently, the supported resources are Amazon ECS
capacity providers, tasks, services, task definitions, clusters, and
container instances.
}

\section{tagKeys}{

The keys of the tags to be
removed.
}

