% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate_credentials.R
\name{locate_credentials}
\alias{locate_credentials}
\title{Locate AWS Credentials}
\usage{
locate_credentials(key = NULL, secret = NULL, session_token = NULL,
  region = NULL, file = NULL, profile = "default",
  default_region = "us-east-1", verbose = FALSE)
}
\arguments{
\item{key}{An AWS Access Key ID}

\item{secret}{An AWS Secret Access Key}

\item{session_token}{Optionally, an AWS Security Token Service (STS) temporary Session Token}

\item{region}{A character string containing the AWS region for the request. If missing, \dQuote{us-east-1} is assumed.}

\item{file}{A character string containing a path to a \samp{.aws/credentials} file.}

\item{profile}{A character string specifying which profile to use from the file. By default, the \dQuote{default} profile is used.}

\item{default_region}{A character string specifying a default string to use of no user-supplied value is found.}

\item{verbose}{A logical indicating whether to be verbose.}
}
\description{
Locate AWS credentials from likely sources
}
\details{
These functions locate values of AWS credentials (access key, secret access key, session token, and region) from likely sources. The order in which these are searched is as follows:
\enumerate{
  \item values passed to the function
  \item environment variables (\env{AWS_ACCESS_KEY_ID}, \env{AWS_SECRET_ACCESS_KEY}, \env{AWS_SESSION_TOKEN}, \env{AWS_DEFAULT_REGION})
  \item an IAM instance role (on the running EC2 instance from which this function is called) as identified by \code{\link[aws.ec2metadata]{metadata}}
  \item a specified profile in a local credentials dot file in the current working directory
  \item the default profile in a local credentials dot file in the current working directory
  \item a specified profile in a global credentials dot file in, typically in \file{~/.aws/credentials}. See \code{\link{use_credentials}} for details
  \item the default profile in a global credentials dot file in, typically in \file{~/.aws/credentials}. See \code{\link{use_credentials}} for details
}
}
\seealso{
\code{\link{signature_v4}}, \code{\link{signature_v2_auth}}, \code{\link{use_credentials}}
}
