% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyvault.R
\name{set_secrets}
\alias{set_secrets}
\title{Add secrets to a keyvault}
\usage{
set_secrets(keyvault, secrets)
}
\arguments{
\item{keyvault}{The \code{Keyvault} object.}

\item{secrets}{The named list of secrets to be added to the keyvault,
where element name corresponds to the secret name.}
}
\value{
None
}
\description{
Add a named list of secrets into the keyvault associated with the
workspace.
}
\examples{
\dontrun{
ws <- load_workspace_from_config()
my_secret <- Sys.getenv("MY_SECRET")
keyvault <- get_default_keyvault(ws)
set_secrets(list("mysecret" = my_secret))
}
}
