% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphabet.R
\name{alphabet}
\alias{alphabet}
\alias{new_alphabet}
\title{Standard base64 alphabets}
\usage{
alphabet(which = "standard")

new_alphabet(chars)
}
\arguments{
\item{which}{default \code{"standard"}. Which base64 alphabet to use.
See details for other values.}

\item{chars}{a character scalar contains 64 unique characters.}
}
\value{
an object of class \code{alphabet}
}
\description{
Create an alphabet from a set of standard base64 alphabets, or use your own.
}
\details{
\itemize{
\item \code{"bcrypt"}: bcrypt alphabet
\item \code{"bin_hex"}: alphabet used in BinHex 4.0 files
\item \code{"crypt"}: crypt(3) alphabet (with . and / as the first two characters)
\item \code{"imap_mutf7"}: alphabet used in IMAP-modified UTF-7 (with + and ,)
\item \code{"standard"}: standard alphabet (with + and /) specified in RFC 4648
\item \code{"url_safe"}: URL-safe alphabet (with - and _) specified in RFC 4648
}

See \href{https://docs.rs/base64/latest/base64/alphabet/index.html#constants}{base64 crate}
from where these definitions come.
}
\examples{
alphabet("standard")
alphabet("bcrypt")
alphabet("bin_hex")
alphabet("crypt")
alphabet("imap_mutf7")
alphabet("url_safe")

new_alphabet("qwertyuiop[]asdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890")
}
