% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/generateA.R
\name{generateA}
\alias{generateA}
\title{Generates a connectivity matrix A.}
\usage{
generateA(p, expNumNeigh, minCoef, maxCoef, cyclic, verbose = FALSE)
}
\arguments{
\item{p}{Number of variables.}

\item{expNumNeigh}{Expected number of neighbors, to be passed to
\code{\link[pcalg]{randDAG}}.}

\item{minCoef}{Minimal edge coefficient. The absolute magnitude of the
coefficients will be sampled uniformly at random from the
range \eqn{[minCoef, maxCoef]}.}

\item{maxCoef}{Maximal edge coefficient. The absolute magnitude of the
coefficients will be sampled uniformly at random from the
range \eqn{[minCoef, maxCoef]}.}

\item{cyclic}{If \code{TRUE}, connectivity matrix will contain at least one
cycle.}

\item{verbose}{If \code{TRUE}, comments will be printed.}
}
\value{
A list with two elements
\itemize{
\item A Connectivity matrix
\item sizeCycle Size of the cycle, if \code{cyclic} was set to \code{TRUE}.
}
}
\description{
Generates a connectivity matrix A with cycle product smaller
 than 1.
}
\details{
If \code{expNumNeigh} and \code{maxCoef} are large, function
may fail to find a connectivity matrix with cycle product smaller one. In this
case, try to lower these parameters.
}

