% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b2DownloadFileByName.R
\name{b2DownloadFileByName}
\alias{b2DownloadFileByName}
\title{Download B2 File by Name.}
\usage{
b2DownloadFileByName(bucketName, fileName, overwrite = FALSE)
}
\arguments{
\item{bucketName}{The name of the bucket containing the requested file.
Bucket names may be obtained through the \code{b2ListBuckets} function in
this package.}

\item{fileName}{The name of the file to be downloaded. File names may be
obtained through the \code{b2ListFileNames} function in this package.}

\item{overwrite}{Binary TRUE or FALSE decision to overwrite any files in the
current working directory, whose names match the downloaded file name.}
}
\value{
If successful the response headers include the Content-Type that was
  specified when the file was uploaded. They also include the X-Bz-FileName
  and X-Bz-Content-Sha1 headers. The X-Bz-FileName uses percent-encoding, as
  if it were a URL parameter. If successful, the file will be downloaded to
  the current working directory.
}
\description{
\code{b2DownloadFileByName} downloads a file from the user's account on the
Backblaze B2 cloud storage product.
}
\details{
This function downloads a file from the user's account on the Backblaze B2
cloud storage product using the file's name only. Files of the same name may
have multiple versions stored on B2. Therefore, only the most recent version
matching the specified filename will be downloaded. Further details regarding
this API call are available here:

\url{https://www.backblaze.com/b2/docs/b2_download_file_by_name.html}

\code{fileName} and \code{bucketName} are mandatory and must be user defined.
\code{overwrite} is optionally user defined and defaults to FALSE.
}
\examples{
\dontrun{
b2DownloadFileByName(bucketName = "this-is-a-uniquely-named-bucket",
fileName = "yourFileName.txt", overwrite = TRUE)
}

}

