% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicm.R
\name{bicm}
\alias{bicm}
\title{Bipartite Configuration Model}
\usage{
bicm(M, tol = 1e-08, max_steps = 200, ...)
}
\arguments{
\item{M}{matrix: a binary matrix}

\item{tol}{numeric, tolerance of algorithm}

\item{max_steps}{numeric, number of times to run \link{loglikelihood_prime_bicm} algorithm}

\item{...}{optional arguments}
}
\value{
matrix: a matrix of probabilities
}
\description{
\code{bicm} estimates cell probabilities under the bipartite configuration model
}
\details{
Given a binary matrix \strong{M}, the Bipartite Configuration Model (BiCM; Saracco et. al. 2015) returns a valued matrix
\strong{B} in which Bij is the \emph{approximate} probability that Mij = 1 in the space of all binary matrices with
the same row and column marginals as \strong{M}. The BiCM yields the closest approximations of the true probabilities
compared to other estimation methods (Neal et al., 2021), and is used by \code{\link[=sdsm]{sdsm()}} to extract the backbone of
a bipartite projection using the stochastic degree sequence model.
}
\examples{
M <- matrix(rbinom(25,1,0.5),5,5)  #A random bipartite graph
bicm(M)
}
\references{
{Saracco, F., Di Clemente, R., Gabrielli, A., & Squartini, T. (2015). Randomizing bipartite networks: The case of the World Trade Web. \emph{Scientific Reports, 5}, 10595. \doi{10.1038/srep10595}}

{Neal, Z. P., Domagalski, R., and Sagan, B. (2021). Comparing Alternatives to the Fixed Degree Sequence Model for Extracting the Backbone of Bipartite Projections. \emph{Scientific Reports}. \doi{10.1038/s41598-021-03238-3}}
}
