% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixedrow.R
\name{hyperg}
\alias{hyperg}
\title{Wrapper for fixedrow()}
\usage{
hyperg(
  B,
  alpha = 0.05,
  signed = FALSE,
  mtc = "none",
  class = "original",
  narrative = FALSE
)
}
\arguments{
\item{B}{An unweighted bipartite graph, as: (1) an incidence matrix in the form of a matrix or sparse \code{\link{Matrix}}; (2) an edgelist in the form of a two-column dataframe; (3) an \code{\link{igraph}} object; (4) a \code{\link{network}} object.
Any rows and columns of the associated bipartite matrix that contain only zeros are automatically removed before computations.}

\item{alpha}{Real: significance level of hypothesis test(s)}

\item{signed}{Boolean: TRUE if signed backbone is to be returned, FALSE if binary backbone is to be returned}

\item{mtc}{string: type of Multiple Test Correction to be applied; can be any method allowed by \code{\link{p.adjust}}.}

\item{class}{string: the class of the returned backbone graph, one of c("original", "matrix", "sparseMatrix", "igraph", "network", "edgelist").
If "original", the backbone graph returned is of the same class as \code{B}.}

\item{narrative}{Boolean: TRUE if suggested text for a manuscript is to be returned.}
}
\description{
Wrapper for fixedrow()
}
