% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.bagger}
\alias{predict.bagger}
\title{Predictions from a bagged model}
\usage{
\method{predict}{bagger}(object, new_data, type = NULL, ...)
}
\arguments{
\item{object}{An object generated by \code{bagger()}.}

\item{new_data}{A data frame of predictors. If a recipe or
formula were originally used, the \strong{original} data should be
passed here instead of a preprocessed version.}

\item{type}{A single character value for the type of
predictions. For regression models, \code{type = 'numeric'} is valid
and \code{'class'} and \code{'prob'} are valid for classification models.}

\item{...}{Not currently used.}
}
\description{
The \code{predict()} function computes predictions from each of the
models in the ensembles and returns a single aggregated value
for each sample in \code{new_data}.
}
\examples{
data(airquality)

set.seed(7687)
mars_bag <- bagger(Ozone ~ ., data = airquality, base_model = "MARS", times = 5)
predict(mars_bag, new_data = airquality[, -1])
}
