% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/out.mcmclist.R
\name{burning.mcmc}
\alias{burning.mcmc}
\title{Burning of MCMC objects}
\usage{
burning.mcmc(mcmclist, ...)
}
\arguments{
\item{mcmclist}{A \emph{mcmc.2pnob} or \emph{mcmc.3pnob} class object.}

\item{...}{Further arguments.}
}
\value{
The burning number for a \emph{mcmc.2pnob} or \emph{mcmc.3pnob} object.
}
\description{
This function gives the number of the first discarded iterations for an MCMC
object of class mcmc.2pnob or mcmc.3pnob.
}
\examples{
# data for model
data("MathTest")

# Only for the first 500 examinees of the data MathTest
# Two-Parameter Normal Ogive Model
model2 <- mcmc.2pnob(MathTest[1:500,], iter = 100, burning = 0)
iter.mcmc(model2)
burning.mcmc(model2)
thin(model2)
parts.mcmc(model2)
model.mcmc(model2)
data.mcmc(model2)

\donttest{
# For all examinees of the data MathTest
# Three-Parameter Normal Ogive Model
model3 <- mcmc.3pnob(MathTest, iter = 3500, burning = 500)
iter.mcmc(model3)
burning.mcmc(model3)
thin(model3)
parts.mcmc(model3)
model.mcmc(model3)
data.mcmc(model3)
}

## End(Not run)

}
\seealso{
\code{\link{mcmc.2pnob}}, \code{\link{mcmc.3pnob}} and
\code{\link{continue.mcmc.bairt}}.
}
\author{
Javier Martínez
}
