% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.c.prior.R
\name{select.c.prior}
\alias{select.c.prior}
\title{Select the c prior for the Three-Parameter Normal Ogive Model}
\usage{
select.c.prior(nitem, m = 20, ...)
}
\arguments{
\item{nitem}{Number of alternatives for each item.}

\item{m}{It is a priori weight assigned to the prior information.
\eqn{m = 20} by default.}

\item{...}{Further arguments.}
}
\value{
A vector length 2, this indicate the \emph{c} (guessing parameter) prior for
\emph{mcmc.3pnob}.
}
\description{
Select the \emph{c} (guessing parameter) prior for \emph{mcmc.3pnob},
through the application of Bayes Modal Estimation Equations.
}
\details{
Because \emph{c} (guessing parameter) is bounded by 0 and 1, a
\eqn{Beta(\alpha, \beta)} prior distribution was proposed by Swaminathan and
Gifford (1986). These parameters are defined as \eqn{\alpha=mp+1} and
\eqn{\beta=m(p-1)+1}, where \eqn{p=1/n} with \emph{n} = number of
alternatives for each item  (Harwell & Baker, 1991, p.386)
}
\examples{
# data for model
data("MathTest")

# selection of the prior for 5 response options
cprior <- select.c.prior(5)

# estimate model only for the first 500 examinees of the data MathTest
model3 <- mcmc.3pnob(MathTest[1:500,], iter = 300, burning = 0,
                    c.prior = cprior)

## End(Not run)

}
\references{
Harwell, M. R, & Baker, F. B. (1991). The use of Prior Distributions in
Marginalized Bayesian Item Parameter Estimation: A Didactic. Psychometrika,
15, 375-389.
}
\seealso{
\code{\link{mcmc.3pnob}} and \code{\link{continue.mcmc.bairt}}.
}
\author{
Javier Martínez
}
