% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createProbMat.R
\name{createProbMat}
\alias{createProbMat}
\title{Creates a probMat class object from user data}
\usage{
createProbMat(x = NULL, pmat = NULL, timeRange = NULL, resolution = NULL)
}
\arguments{
\item{x}{A data.frame containing the start and end date of the timespan of each event. Dates should be in BP, with the first column defining the start and the second column defining the end of the timespan.}

\item{pmat}{A matrix of aoristic weights (probabilities), with row representing events and column representing timeblocks.}

\item{timeRange}{A vector of two numerical values representing the start and end of the window of analysis in BP.}

\item{resolution}{Resolution of the timeblock. Ignored if \code{pmat} is provided.}
}
\value{
An object of class \code{probMat}.
}
\description{
Converts either a data.frame with the start and end date of each event or matrix of probabilities values into a \code{probMat} class object.
}
