% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_Friedman3.R
\name{sim_Friedman3}
\alias{sim_Friedman3}
\title{Simulated Regression Problem Friedman 3}
\usage{
sim_Friedman3(n, sd = 0.1)
}
\arguments{
\item{n}{number of data points to create}

\item{sd}{Standard deviation of noise. The default value of 125 gives
a signal to noise ratio (i.e., the ratio of the standard deviations) of
3:1. Thus, the variance of the function itself (without noise)
accounts for 90\% of the total variance.}
}
\value{
Returns a list with components
\item{x}{input values (independent variables)}
\item{y}{output values (dependent variable)}
}
\description{
The regression problem Friedman 3 as described in Friedman (1991) and
Breiman (1996). Inputs are 4 independent variables uniformly
distributed over the ranges
\deqn{0 \le x1 \le 100}
\deqn{40 \pi \le x2 \le 560 \pi}
\deqn{0 \le x3 \le 1}
\deqn{1 \le x4 \le 11}
The outputs are created according to the formula
\deqn{\mbox{atan}((x2 x3 - (1/(x2 x4)))/x1) + e}{
y = atan ((x2 x3 - (1/(x2 x4)))/x1) + e}
where e is \eqn{N(0,sd^2)}.
}
\examples{
sim_Friedman3(n=100, sd=0.1)
}
\references{
Breiman, Leo (1996) Bagging predictors. Machine Learning 24,
pages 123-140. \cr
Friedman, Jerome H. (1991) Multivariate adaptive regression
splines. The Annals of Statistics 19 (1), pages 1-67.
}
\seealso{
Other bark simulation functions: 
\code{\link{sim_Friedman1}()},
\code{\link{sim_Friedman2}()},
\code{\link{sim_circle}()}

Other bark functions: 
\code{\link{bark-package-deprecated}},
\code{\link{bark-package}},
\code{\link{bark}()},
\code{\link{sim_Friedman1}()},
\code{\link{sim_Friedman2}()},
\code{\link{sim_circle}()}
}
\concept{bark functions}
\concept{bark simulation functions}
