% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-events.R
\name{create_onset}
\alias{create_onset}
\alias{create_diapause}
\alias{create_mortality}
\alias{create_events}
\title{Create phenological events (onset/diapause/mortality)}
\usage{
create_onset(
  template,
  doys = NULL,
  stations = NULL,
  dates = NULL,
  .quiet = FALSE
)

create_diapause(
  template,
  doys = NULL,
  stations = NULL,
  dates = NULL,
  .quiet = FALSE
)

create_mortality(
  template,
  doys = NULL,
  stations = NULL,
  dates = NULL,
  .quiet = FALSE
)
}
\arguments{
\item{template}{SpatRaster or data frame that determines the
spatial and temporal extent of the result. If a single-layer SpatRaster was
passed, the temporal extent should be defined by using \code{dates}.}

\item{doys}{Numeric vector, (multi-layer) SpatRaster or data frame that
specifies the days of year when the event is triggered. Vectors will define
the events globally whereas SpatRasters allow spatially explict definitions.
For the creation of events based on stations, data frames are used.
In that case, the field \code{station} specifies the station name and \code{doy} indicates the
respective day of year.}

\item{stations}{If \code{template} is a SpatRaster and \code{doys} is a data frame,
stations should be passed to define which cells are affected. See \code{\link[=stations_create]{stations_create()}} for details.}

\item{dates}{Dates to define the temporal extent of the output if \code{template}
is a single-layer SpatRaster.}

\item{.quiet}{If \code{TRUE}, messages are suppressed.}
}
\value{
A logical multi-layer SpatRaster. Each layer represents one date.
}
\description{
Generate onset, diapause or mortality manually to be able to run \code{\link[=phenology]{phenology()}}
with observed or arbitrary inputs.
}
\section{Functions}{
\itemize{
\item \code{create_onset()}: Create a onset.

\item \code{create_diapause()}: Create a diapause.

\item \code{create_mortality()}: Create mortality events.

}}
\examples{
\donttest{
# load sample data
d <- barrks_data('stations')

# create onset, diapause, mortality
on <- create_onset(d, lubridate::yday('2015-04-15'))
dia <- create_diapause(d, lubridate::yday('2015-08-15'))
mort <- create_mortality(d, lubridate::yday('2015-11-15'))

# claculate phenologe
p <- phenology('phenips-clim', d, .quiet = TRUE,
               .onset = on, .diapause = dia, .mortality = mort)

# plot development
plot_development_diagram(p, .lwd = 4)
}
}
