% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-suntimes.R
\name{create_suntimes_df}
\alias{create_suntimes_df}
\title{Create a data frame of sunrises and sunsets}
\usage{
create_suntimes_df(coords, dates, tz = Sys.timezone(), .quiet = FALSE)
}
\arguments{
\item{coords}{Data frame with the fields \code{station}, \code{lat} and \code{lon}. Defines
the latitude and longitude for the respective stations.}

\item{dates}{Dates that should be processed.}

\item{tz}{Timezone of the results.}

\item{.quiet}{If \code{TRUE}, messages are suppressed.}
}
\value{
A data frame with the columns \code{date}, \code{station} and \code{sunrise} and
\code{sunset}. The values of sunrise and sunset indicate the respective time in
minutes.
}
\description{
Generate a data frame that specifies sunrises and sunsets for different
coordinates and dates.
The package \code{suncalc} is required to use this function.
}
\examples{
\dontshow{if (rlang::is_installed("suncalc")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
date_start <- as.Date('2020-01-01')
date_end <- as.Date('2020-12-31')

st <- create_suntimes_df(barrks_data('station_coords'),
                         seq(date_start, date_end, by = 'day'),
                         .quiet = TRUE)

# print results of station 'Freiburg'
st[st$station == 'Freiburg',]
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=create_suntimes_rsts]{create_suntimes_rsts()}}
}
