\name{var_selection_by_permute}
\alias{var_selection_by_permute}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Perform Variable Selection using Three Threshold-based Procedures
}
\description{
Performs variable selection using the three thresholding methods introduced in Bleich et al. (2013). 
}
\usage{
var_selection_by_permute(bart_machine, 
num_reps_for_avg = 10, num_permute_samples = 100, 
num_trees_for_permute = 20, alpha = 0.05, 
plot = TRUE, num_var_plot = Inf, bottom_margin = 10)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{bart_machine}{
An object of class ``bartMachine''.
}
  \item{num_reps_for_avg}{
Number of replicates to over over to for the BART model's variable inclusion proportions.
}
  \item{num_permute_samples}{
Number of permutations of the response to be made to generate the ``null'' permutation distribution.
}
  \item{num_trees_for_permute}{
Number of trees to use in the variable selection procedure. As with \cr \code{\link{investigate_var_importance}}, a small number of trees should be used to force variables to compete for entry into the model. Note that this number is used to estimate both the ``true'' and ``null'' variable inclusion proportions.
}
  \item{alpha}{
Cut-off level for the thresholds.
}
  \item{plot}{
If TRUE, a plot showing which variables are selected by each of the procedures is generated.
}
  \item{num_var_plot}{
Number of variables (in order of decreasing variable inclusion proportion) to be plotted.
}
  \item{bottom_margin}{
A display parameter that adjusts the bottom margin of the graph if labels are clipped. The scale of this parameter is the same as set with \code{par(mar = c(....))} in R.
Higher values allow for more space if the crossed covariate names are long. Note that making this parameter too large will prevent plotting and the plot function in R will throw an error.
}
}
\details{
See Bleich et al. (2013) for a complete description of the procedures outlined above as well as the corresponding vignette for a brief summary with examples. 
}
\value{
Invisibly, returns a list with the following components:

  \item{important_vars_local_names}{Names of the variables chosen by the Local procedure.}
  \item{important_vars_global_max_names}{Names of the variables chosen by the Global Max procedure.}
    \item{important_vars_global_se_names}{Names of the variables chosen by the Global SE procedure.}
    \item{important_vars_local_col_nums}{Column numbers of the variables chosen by the Local procedure.}
  \item{important_vars_global_max_col_nums}{Column numbers of the variables chosen by the Global Max procedure.}
    \item{important_vars_global_se_col_nums}{Column numbers of the variables chosen by the Global SE procedure.}
    \item{var_true_props_avg}{The variable inclusion proportions for the actual data.}
  \item{permute_mat}{The permutation distribution generated by permuting the response vector.}
  }
\references{
J Bleich, A Kapelner, ST Jensen, and EI George. Variable Selection Inference for Bayesian
Additive Regression Trees. ArXiv e-prints, 2013.

A Kapelner and J Bleich. bartMachine: Machine Learning with Bayesian Additive Regression Trees, arXiv preprints, 2013
}
\author{
Adam Kapelner and Justin Bleich
}
\note{
Although the reference only explores regression settings, this procedure is applicable to both regression and classification problems.
This function is parallelized by the number of cores set in \code{\link{set_bart_machine_num_cores}}.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{var_selection_by_permute}}, \code{\link{investigate_var_importance}}
}
\examples{
\dontrun{
#generate Friedman data
set.seed(11)
n  = 300 
p = 20 ##15 useless predictors 
X = data.frame(matrix(runif(n * p), ncol = p))
y = 10 * sin(pi* X[ ,1] * X[,2]) +20 * (X[,3] -.5)^2 + 10 * X[ ,4] + 5 * X[,5] + rnorm(n)

##build BART regression model (not actuall used in variable selection)
bart_machine = bartMachine(X, y)

#variable selection
var_sel = var_selection_by_permute(bart_machine)
print(var_sel$important_vars_local_names)
print(var_sel$important_vars_global_max_names)
}
  }
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
