% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acceptenceRate.R
\name{acceptRate}
\alias{acceptRate}
\title{acceptRate}
\usage{
acceptRate(trees)
}
\arguments{
\item{trees}{A data frame created by extractTreeData function.
Displays a division on the plot to separate prior and post burn-in iterations.}
}
\value{
A ggplot object plot of acceptance rate.
}
\description{
Plots the acceptance rate of trees from a BART model.
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
# Load the dbarts package to access the bart function
library(dbarts)
# Get Data
df <- na.omit(airquality)
# Create Simple dbarts Model For Regression:
set.seed(1701)
dbartModel <- bart(df[2:6], df[,1], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)
# Tree Data
trees_data <- extractTreeData(model = dbartModel, data = df)
acceptRate(trees = trees_data)}


}
