% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bbdb.R
\name{get_bbdb}
\alias{get_bbdb}
\title{Get an up to date copy of the Baseball Databank.}
\usage{
get_bbdb(table = NULL, downloadZip = FALSE, AllTables = FALSE)
}
\arguments{
\item{table}{The tables you would like to download. Uses Lahman table names Ex. "Batting", "Master", "AllstarFull", etc...
If this argument is left as NULL, the function will download all twenty-seven tables.}

\item{downloadZip}{If true, this will download a zip file of all twenty-seven tables in .csv format to your working directory.}

\item{AllTables}{If true, this will download all the tables in the database. The default is set to false.}
}
\description{
Download the newest version of the Baseball Databank from the Chadwick Bureau GitHub repository. This is the source of
Sean Lahman's baseball database and is always under development. This function will read the .csv files and return them as data frames.
There is also an option to download the entire directory.
}
\examples{

get_bbdb(table = "Batting")

\dontrun{
get_bbdb(table = c("Batting", "Pitching"))
}

\dontrun{
get_bbdb(downloadZip = TRUE)
}
}
\keyword{data}
\keyword{database,}
\keyword{frame}
