% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woba_values.R
\name{wOBA_values}
\alias{wOBA_values}
\title{Return wOBA values per season}
\usage{
wOBA_values(BattingTable, PitchingTable, FieldingTable, Sep.Leagues = FALSE,
  Fangraphs = FALSE)
}
\arguments{
\item{BattingTable}{A full batting table from the \code{Lahman} package or the Chadwick Bureau GitHub repository.
Any subsetting or removal of players will affect your results. All players for each year are recommended.}

\item{PitchingTable}{A full pitching table from the \code{Lahman} package or the Chadwick Bureau GitHub repository.
Any subsetting or removal of players will affect your results. All players for each year are recommended.}

\item{FieldingTable}{A full batting table from the \code{Lahman} package or the Chadwick Bureau GitHub repository.
Any subsetting or removal of players will affect your results. All players for each year are recommended.}

\item{Sep.Leagues}{If TRUE, this will split the calculation and return unique wOBA values for the various leagues. This can be
helpful in handling Designated Hitters and National League pitchers. It also isolates the park factors to their respective leagues.}

\item{Fangraphs}{if TRUE the function will return the Fangraphs wOBA values. By default the function uses a method adapted from
Tom Tango. These values are often very close to Fangraphs, but are not the same due to Fangraphs using a different algorithm.
This can not be used in conjunction with the \code{Sep.Leagues} argument because Fangraphs does not separate FIP constants by league.}
}
\description{
Get wOBA values for each year in your database. This calculation requires all fields of
the Pitching, Fielding and Batting tables from the Lahman package, or a comparable data set. The function uses
a version of Tom Tango's wOBA formula by default, but can also return Fangraphs wOBA values.
}
\examples{

data("Batting2016")
head(Batting2016)
data("Pitching2016")
head(Pitching2016)
data("Fielding2016")
head(Fielding2016)

woba_df <- wOBA_values(Batting2016, Pitching2016, Fielding2016, Sep.Leagues=FALSE, Fangraphs=FALSE)

}
\keyword{average,}
\keyword{base}
\keyword{fangraphs}
\keyword{on}
\keyword{wOBA,}
\keyword{woba,}
